// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/browser/ui/webui/omnibox/omnibox.mojom
//

package org.chromium.mojom;

public final class OmniboxResultMojo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 40;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(40, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public boolean done;
    public int timeSinceOmniboxStartedMs;
    public String host;
    public boolean isTypedHost;
    public AutocompleteMatchMojo[] combinedResults;
    public AutocompleteResultsForProviderMojo[] resultsByProvider;

    private OmniboxResultMojo(int version) {
        super(STRUCT_SIZE, version);
    }

    public OmniboxResultMojo() {
        this(0);
    }

    public static OmniboxResultMojo deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static OmniboxResultMojo decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        OmniboxResultMojo result = new OmniboxResultMojo(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.done = decoder0.readBoolean(8, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.isTypedHost = decoder0.readBoolean(8, 1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.timeSinceOmniboxStartedMs = decoder0.readInt(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.host = decoder0.readString(16, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
            {
                org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.combinedResults = new AutocompleteMatchMojo[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    result.combinedResults[i1] = AutocompleteMatchMojo.decode(decoder2);
                }
            }
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
            {
                org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                result.resultsByProvider = new AutocompleteResultsForProviderMojo[si1.elementsOrVersion];
                for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                    org.chromium.mojo.bindings.Decoder decoder2 = decoder1.readPointer(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    result.resultsByProvider[i1] = AutocompleteResultsForProviderMojo.decode(decoder2);
                }
            }
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(done, 8, 0);
        encoder0.encode(isTypedHost, 8, 1);
        encoder0.encode(timeSinceOmniboxStartedMs, 12);
        encoder0.encode(host, 16, false);
        if (combinedResults == null) {
            encoder0.encodeNullPointer(24, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(combinedResults.length, 24, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < combinedResults.length; ++i0) {
                encoder1.encode(combinedResults[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
        if (resultsByProvider == null) {
            encoder0.encodeNullPointer(32, false);
        } else {
            org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(resultsByProvider.length, 32, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
            for (int i0 = 0; i0 < resultsByProvider.length; ++i0) {
                encoder1.encode(resultsByProvider[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
            }
        }
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        OmniboxResultMojo other = (OmniboxResultMojo) object;
        if (this.done != other.done)
            return false;
        if (this.timeSinceOmniboxStartedMs != other.timeSinceOmniboxStartedMs)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.host, other.host))
            return false;
        if (this.isTypedHost != other.isTypedHost)
            return false;
        if (!java.util.Arrays.deepEquals(this.combinedResults, other.combinedResults))
            return false;
        if (!java.util.Arrays.deepEquals(this.resultsByProvider, other.resultsByProvider))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(done);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(timeSinceOmniboxStartedMs);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(host);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(isTypedHost);
        result = prime * result + java.util.Arrays.deepHashCode(combinedResults);
        result = prime * result + java.util.Arrays.deepHashCode(resultsByProvider);
        return result;
    }
}

